<?php
    $team = getContent('team.content', true);
   $teams = getContent('team.element', false, 8, false);
?>
<section class="team-section pt-60 pb-120">
    <div class="container">
        <div class="section__header section__header__center">
            <span class="section__cate">
                <?php echo e(__(@$team->data_values->title)); ?>

            </span>
            <h3 class="section__title"><?php echo e(__($team->data_values->heading)); ?></h3>
            <p>
               <?php echo e(__(@$team->data_values->sub_heading)); ?>

            </p>
        </div>
        <div class="row g-4 justify-content-center">

            <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="team__item">
                        <div class="team__item-thumb">
                            <img src="<?php echo e(getImage('assets/images/frontend/team/'. $value->data_values->member, '600x600')); ?>" alt="<?php echo app('translator')->get('team'); ?>">
                            <a href="<?php echo e(getImage('assets/images/frontend/team/'. $value->data_values->member, '600x600')); ?>" class="view-img" data-lightbox><i class="las la-plus"></i></a>
                        </div>
                        <div class="team__item-content">
                            <h5 class="team__item-title"><?php echo e(__($value->data_values->name)); ?></h5>
                            <span class="text--base"><?php echo e(__($value->data_values->designation)); ?></span>
                            <span class="d-block"><?php echo app('translator')->get('Complete Delivery'); ?> : <span class="text--base"><?php echo e(__($value->data_values->total_delivery)); ?></span></span>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>


<?php /**PATH /home/highogyr/public_html/core/resources/views/templates/basic/sections/team.blade.php ENDPATH**/ ?>